/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.potion;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Potion;
import net.minecraft.potion.Potions;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class PotionUtils {
    private static final IFormattableTextComponent field_242400_a = new TranslationTextComponent("effect.none").func_240699_a_(TextFormatting.GRAY);

    public static List<EffectInstance> func_185189_a(ItemStack itemStack) {
        return PotionUtils.func_185185_a(itemStack.func_77978_p());
    }

    public static List<EffectInstance> func_185186_a(Potion potion, Collection<EffectInstance> collection) {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(potion.func_185170_a());
        arrayList.addAll(collection);
        return arrayList;
    }

    public static List<EffectInstance> func_185185_a(@Nullable CompoundNBT compoundNBT) {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(PotionUtils.func_185187_c(compoundNBT).func_185170_a());
        PotionUtils.func_185193_a(compoundNBT, arrayList);
        return arrayList;
    }

    public static List<EffectInstance> func_185190_b(ItemStack itemStack) {
        return PotionUtils.func_185192_b(itemStack.func_77978_p());
    }

    public static List<EffectInstance> func_185192_b(@Nullable CompoundNBT compoundNBT) {
        ArrayList arrayList = Lists.newArrayList();
        PotionUtils.func_185193_a(compoundNBT, arrayList);
        return arrayList;
    }

    public static void func_185193_a(@Nullable CompoundNBT compoundNBT, List<EffectInstance> list) {
        if (compoundNBT != null && compoundNBT.func_150297_b("CustomPotionEffects", 9)) {
            ListNBT listNBT = compoundNBT.func_150295_c("CustomPotionEffects", 10);
            for (int i = 0; i < listNBT.size(); ++i) {
                CompoundNBT compoundNBT2 = listNBT.func_150305_b(i);
                EffectInstance \u26032 = EffectInstance.func_82722_b(compoundNBT2);
                if (\u26032 == null) continue;
                list.add(\u26032);
            }
        }
    }

    public static int func_190932_c(ItemStack itemStack) {
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        if (compoundNBT != null && compoundNBT.func_150297_b("CustomPotionColor", 99)) {
            return compoundNBT.func_74762_e("CustomPotionColor");
        }
        return PotionUtils.func_185191_c(itemStack) == Potions.field_185229_a ? 0xF800F8 : PotionUtils.func_185181_a(PotionUtils.func_185189_a(itemStack));
    }

    public static int func_185183_a(Potion potion) {
        return potion == Potions.field_185229_a ? 0xF800F8 : PotionUtils.func_185181_a(potion.func_185170_a());
    }

    public static int func_185181_a(Collection<EffectInstance> collection) {
        int n;
        int n2 = 3694022;
        if (collection.isEmpty()) {
            return 3694022;
        }
        float \u26032 = 0.0f;
        float \u26033 = 0.0f;
        float \u26034 = 0.0f;
        n = 0;
        for (EffectInstance effectInstance : collection) {
            if (!effectInstance.func_188418_e()) continue;
            int n3 = effectInstance.func_188419_a().func_76401_j();
            \u2603 = effectInstance.func_76458_c() + 1;
            \u26032 += (float)(\u2603 * (n3 >> 16 & 0xFF)) / 255.0f;
            \u26033 += (float)(\u2603 * (n3 >> 8 & 0xFF)) / 255.0f;
            \u26034 += (float)(\u2603 * (n3 >> 0 & 0xFF)) / 255.0f;
            n += \u2603;
        }
        if (n == 0) {
            return 0;
        }
        \u26032 = \u26032 / (float)n * 255.0f;
        \u26033 = \u26033 / (float)n * 255.0f;
        \u26034 = \u26034 / (float)n * 255.0f;
        return (int)\u26032 << 16 | (int)\u26033 << 8 | (int)\u26034;
    }

    public static Potion func_185191_c(ItemStack itemStack) {
        return PotionUtils.func_185187_c(itemStack.func_77978_p());
    }

    public static Potion func_185187_c(@Nullable CompoundNBT compoundNBT) {
        if (compoundNBT == null) {
            return Potions.field_185229_a;
        }
        return Potion.func_185168_a(compoundNBT.func_74779_i("Potion"));
    }

    public static ItemStack func_185188_a(ItemStack itemStack, Potion potion) {
        ResourceLocation resourceLocation = Registry.field_212621_j.func_177774_c(potion);
        if (potion == Potions.field_185229_a) {
            itemStack.func_196083_e("Potion");
        } else {
            itemStack.func_196082_o().func_74778_a("Potion", resourceLocation.toString());
        }
        return itemStack;
    }

    public static ItemStack func_185184_a(ItemStack itemStack, Collection<EffectInstance> collection) {
        if (collection.isEmpty()) {
            return itemStack;
        }
        CompoundNBT compoundNBT = itemStack.func_196082_o();
        ListNBT \u26032 = compoundNBT.func_150295_c("CustomPotionEffects", 9);
        for (EffectInstance effectInstance : collection) {
            \u26032.add(effectInstance.func_82719_a(new CompoundNBT()));
        }
        compoundNBT.func_218657_a("CustomPotionEffects", \u26032);
        return itemStack;
    }

    public static void func_185182_a(ItemStack itemStack, List<ITextComponent> list2, float f) {
        List<ITextComponent> list2;
        Object object;
        List<EffectInstance> list3 = PotionUtils.func_185189_a(itemStack);
        ArrayList \u26032 = Lists.newArrayList();
        if (list3.isEmpty()) {
            list2.add(field_242400_a);
        } else {
            for (EffectInstance effectInstance2 : list3) {
                EffectInstance effectInstance2;
                object = new TranslationTextComponent(effectInstance2.func_76453_d());
                Effect \u26033 = effectInstance2.func_188419_a();
                Map<Attribute, AttributeModifier> \u26034 = \u26033.func_111186_k();
                if (!\u26034.isEmpty()) {
                    for (Map.Entry<Attribute, AttributeModifier> entry : \u26034.entrySet()) {
                        AttributeModifier attributeModifier = entry.getValue();
                        \u2603 = new AttributeModifier(attributeModifier.func_111166_b(), \u26033.func_111183_a(effectInstance2.func_76458_c(), attributeModifier), attributeModifier.func_220375_c());
                        \u26032.add(new Pair((Object)entry.getKey(), (Object)\u2603));
                    }
                }
                if (effectInstance2.func_76458_c() > 0) {
                    object = new TranslationTextComponent("potion.withAmplifier", object, new TranslationTextComponent("potion.potency." + effectInstance2.func_76458_c()));
                }
                if (effectInstance2.func_76459_b() > 20) {
                    object = new TranslationTextComponent("potion.withDuration", object, EffectUtils.func_188410_a(effectInstance2, f));
                }
                list2.add(object.func_240699_a_(\u26033.func_220303_e().func_220306_a()));
            }
        }
        if (!\u26032.isEmpty()) {
            list2.add(StringTextComponent.field_240750_d_);
            list2.add(new TranslationTextComponent("potion.whenDrank").func_240699_a_(TextFormatting.DARK_PURPLE));
            for (EffectInstance effectInstance2 : \u26032) {
                object = (AttributeModifier)effectInstance2.getSecond();
                double \u26035 = ((AttributeModifier)object).func_111164_d();
                double \u26036 = ((AttributeModifier)object).func_220375_c() == AttributeModifier.Operation.MULTIPLY_BASE || ((AttributeModifier)object).func_220375_c() == AttributeModifier.Operation.MULTIPLY_TOTAL ? ((AttributeModifier)object).func_111164_d() * 100.0 : ((AttributeModifier)object).func_111164_d();
                if (\u26035 > 0.0) {
                    list2.add(new TranslationTextComponent("attribute.modifier.plus." + ((AttributeModifier)object).func_220375_c().func_220371_a(), ItemStack.field_111284_a.format(\u26036), new TranslationTextComponent(((Attribute)effectInstance2.getFirst()).func_233754_c_())).func_240699_a_(TextFormatting.BLUE));
                    continue;
                }
                if (!(\u26035 < 0.0)) continue;
                list2.add(new TranslationTextComponent("attribute.modifier.take." + ((AttributeModifier)object).func_220375_c().func_220371_a(), ItemStack.field_111284_a.format(\u26036 *= -1.0), new TranslationTextComponent(((Attribute)effectInstance2.getFirst()).func_233754_c_())).func_240699_a_(TextFormatting.RED));
            }
        }
    }
}

